// To parse this JSON data, do
//
//     final savingsHistoryResponseModel = savingsHistoryResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/model/global/meassage_model.dart';
import 'package:viserpay/data/model/savings/organaization_list_response_model.dart';

SavingsHistoryResponseModel savingsHistoryResponseModelFromJson(String str) => SavingsHistoryResponseModel.fromJson(json.decode(str));

String savingsHistoryResponseModelToJson(SavingsHistoryResponseModel data) => json.encode(data.toJson());

class SavingsHistoryResponseModel {
  final String? remark;
  final String? status;
  final Message? message;
  final Data? data;

  SavingsHistoryResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory SavingsHistoryResponseModel.fromJson(Map<String, dynamic> json) => SavingsHistoryResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json['data']),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
      };
}

class Data {
  final Accounts? accounts;
  final String? organizationImagePath;

  Data({
    this.accounts,
    this.organizationImagePath,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        accounts: json["accounts"] == null ? null : Accounts.fromJson(json["accounts"]),
        organizationImagePath: json['organization_image_path'],
      );
}

class Accounts {
  final List<DpsHistoryData>? running;
  final List<DpsHistoryData>? matured;
  final List<DpsHistoryData>? canceled;
  Accounts({
    this.running,
    this.matured,
    this.canceled,
  });

  factory Accounts.fromJson(Map<String, dynamic> json) => Accounts(
        running: json["running"] == null ? [] : List<DpsHistoryData>.from(json["running"]!.map((x) => DpsHistoryData.fromJson(x))),
        matured: json["matured"] == null ? [] : List<DpsHistoryData>.from(json["matured"]!.map((x) => DpsHistoryData.fromJson(x))),
        canceled: json["canceled"] == null ? [] : List<DpsHistoryData>.from(json["canceled"]!.map((x) => DpsHistoryData.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "running": running == null ? [] : List<DpsHistoryData>.from(running!.map((x) => x.toJson())),
        "matured": matured == null ? [] : List<DpsHistoryData>.from(matured!.map((x) => x.toJson())),
        "canceled": canceled == null ? [] : List<DpsHistoryData>.from(canceled!.map((x) => x)),
      };
}

class DpsHistoryData {
  final String? id;
  final String? userId;
  final String? accountId;
  final String? dpsPlanId;
  final String? organizationId;
  final String? nomineeId;
  final String? balance;
  final String? lastInstallmentAt;
  final String? nextInstallmentDate;
  final String? status;
  final String? createdAt;
  final String? updatedAt;
  final DpsPlan? dpsPlan;
  final List<Installment>? installments;

  DpsHistoryData({
    this.id,
    this.userId,
    this.accountId,
    this.dpsPlanId,
    this.organizationId,
    this.nomineeId,
    this.balance,
    this.lastInstallmentAt,
    this.nextInstallmentDate,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.dpsPlan,
    this.installments,
  });

  factory DpsHistoryData.fromJson(Map<String, dynamic> json) {
    printX(json["organization"]);
    return DpsHistoryData(
      id: json["id"].toString(),
      userId: json["user_id"].toString(),
      accountId: json["account_id"].toString(),
      dpsPlanId: json["dps_plan_id"].toString(),
      organizationId: json["organization_id"].toString(),
      nomineeId: json["nominee_id"].toString(),
      balance: json["balance"].toString(),
      lastInstallmentAt: json["last_installment_at"].toString(),
      nextInstallmentDate: json["next_installment_date"].toString(),
      status: json["status"].toString(),
      createdAt: json["created_at"].toString(),
      updatedAt: json["updated_at"].toString(),
      dpsPlan: json["dpsplan"] == null ? null : DpsPlan.fromJson(json["dpsplan"]),
      installments: json["installments"] == null ? [] : List<Installment>.from(json["installments"]!.map((x) => Installment.fromJson(x))),
    );
  }

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "account_id": accountId,
        "dps_plan_id": dpsPlanId,
        "organization_id": organizationId,
        "nominee_id": nomineeId,
        "balance": balance,
        "last_installment_at": lastInstallmentAt,
        "next_installment_date": nextInstallmentDate,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "dpsplan": dpsPlan?.toJson(),
        "installments": installments == null ? [] : List<dynamic>.from(installments!.map((x) => x.toJson())),
      };
}

class Installment {
  final String? id;
  final String? userId;
  final String? trx;
  final String? savingAccountId;
  final String? amount;
  final String? installmentPaidAt;
  final String? penaltyAmount;
  final String? status;
  final String? createdAt;
  final String? updatedAt;

  Installment({
    this.id,
    this.userId,
    this.trx,
    this.savingAccountId,
    this.amount,
    this.installmentPaidAt,
    this.penaltyAmount,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory Installment.fromJson(Map<String, dynamic> json) => Installment(
        id: json["id"].toString(),
        userId: json["user_id"].toString(),
        trx: json["trx"].toString(),
        savingAccountId: json["saving_account_id"].toString(),
        amount: json["amount"].toString(),
        installmentPaidAt: json["installment_paid_at"] ?? "",
        penaltyAmount: json["penalty_amount"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "trx": trx,
        "saving_account_id": savingAccountId,
        "amount": amount,
        "installment_paid_at": installmentPaidAt,
        "penalty_amount": penaltyAmount,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
